import sys
import os
import re
import subprocess
from os import walk
from os import popen
from os import path

# !predefines!
skip_compile = False
uselib_std = False
uselib_math = True
user_libs = '' # -Wl,-I\"d:\\.um\\c++\\labcenter\\CM4\\demos\\stm32f401\\.extra\\FFT\\src\\lib\\00-STM32F4xx_STANDARD_PERIPHERAL_DRIVERS\\CMSIS\\Lib\\GCC\" -larm_cortexM4lf_math'
fname_output = 'main.elf'
dir_output = '.o'
linker_script = 'STM32F401XE.ld'
defines = ['STM32F4XX', 'STM32F401xx', 'STM32F401xE', 'DEBUG', 'USE_HAL_DRIVER', 'KEIL_IDE', 'DELAY_SLEEP']
toolchain_path = 'd:\\.um\\c++\\labcenter\\tools\\SystemWorkbench_STM32\\plugins\\fr.ac6.mcu.externaltools.arm-none.win32_1.15.0.201708311556\\tools\\compiler\\bin';

class bcolors:
	MAGENTA = '\033[95m'
	HEADER = '\033[96m'
	OKGREEN = '\033[92m'
	WARNING = '\033[93m'
	INFO = '\033[93m'
	FAIL = '\033[91m'
	ENDC = '\033[0m'
	BOLD = '\033[1m'
	UNDERLINE = '\033[4m'

class Module:
	def __init__(self, dir, fname, ext):
		self.dir = dir
		self.fname = fname
		self.ext = ext
		
def run(cmd):
	return subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, shell=True, universal_newlines=True).stdout.read()

def is_file_modified(path_src, path_o):
	#print('Test ' + path_o)
	if not os.path.exists(path_o):
		return True
	tm_src = os.stat(path_src).st_mtime
	tm_o = os.stat(path_o).st_mtime
	#print('times: ' + tm_src + ' vs ' + tm_o)
	return tm_src > tm_o
	
def get_modules():
	modules = []
	inc_dirs = []
	for(dirpath,dirnames,filenames) in walk('.\src'):	#os.getcwd()
		h_found = False
		for fn in filenames:
			fname, ext = os.path.splitext(fn)
			if (ext == '.c') or (ext == '.s'):
				f = Module(dirpath, fname, ext)
				modules.append(f)
			if ext == '.h':
				h_found = True
		if h_found:
			inc_dirs.extend([dirpath])
	return (modules, inc_dirs)
	
all_modules, inc_dirs = get_modules()

os.system('cls')	# activate VT100 emulation forsyntax colorizing
print('Python: ' + bcolors.INFO + sys.version + bcolors.ENDC)

# Read used modules list if exists
if not os.path.exists("modules.list"):
	print('Buid scenario file "modules.list" is not found\n');
	f = open("modules.list", "wt")
	for m in all_modules:
		print('{0}\\{1}{2}'.format(m.dir,m.fname,m.ext), file=f)
	print(bcolors.INFO + 'File "modules.list" is created successfully\nEdit it to select modules you want to build' + bcolors.ENDC)
	sys.exit(0)

file = open("modules.list", "rt")
module_fullnames_used = file.readlines()
module_fullnames_used = [x.strip() for x in module_fullnames_used]	# remove '\n'
modules = []
for m in all_modules:
	fullnm = '{0}\\{1}{2}'.format(m.dir,m.fname,m.ext)
	if fullnm in module_fullnames_used:
		modules.append(m)
include_dirs = ' '.join(map(lambda d: '-I"'+d+'"',inc_dirs))
objects_list = ' '.join(map(lambda m: '"'+dir_output+'\\'+m.fname+'.o"',modules))

cflags = '-gdwarf-2 -mcpu=cortex-m4 -mthumb -mfloat-abi=hard -mfpu=fpv4-sp-d16 -O0 -g3 -Wall -fmessage-length=0 -ffunction-sections -c -MMD -MP ' + include_dirs + ''.join(map(lambda d: ' -D'+d, defines))
asmflags = '-mcpu=cortex-m4 -mthumb -mfloat-abi=hard -mfpu=fpv4-sp-d16 -g ' + include_dirs
lflags = '-mcpu=cortex-m4 -mthumb -mfloat-abi=hard -mfpu=fpv4-sp-d16 -T"{0}" -Wl,--gc-sections -o"{1}" --specs=rdimon.specs '.format(linker_script, fname_output) + user_libs

if not uselib_std:
	lflags = lflags + ' -nostdlib'
if uselib_math:
	lflags = lflags + ' -lm'

c_compiler = toolchain_path + '\\arm-none-eabi-gcc'
asm_compiler = toolchain_path + '\\arm-none-eabi-as'
linker = toolchain_path + '\\arm-none-eabi-gcc'
prnsize = toolchain_path + '\\arm-none-eabi-size'

if not os.path.exists(dir_output):
	os.makedirs(dir_output)

error = False
#stage Compiling
if not skip_compile:
	print(bcolors.HEADER + 'Compiling' + bcolors.ENDC)
	for m in modules:
		if (m.fname[0] == '#'):
			continue
		full_name = '{0}\\{1}{2}'.format(m.dir, m.fname, m.ext)
		fname = dir_output + '\\' + m.fname;
		# Incremental compilation
		if not is_file_modified(full_name, fname + '.o'):
			continue
		cmd = []
		if m.ext == '.c':
			cmd = '{0} {1} -MF"{2}.d" -MT"{2}.o" -o "{2}.o" "{3}"'.format(c_compiler, cflags, fname, full_name)
		if m.ext == '.s':
			cmd = '{0} {1} -o "{2}.o" "{3}"'.format(asm_compiler, asmflags, fname, full_name)
		result = run(cmd)
		found = re.search(r'error:', result.lower())
		if found != None:
			print(bcolors.MAGENTA + '[FAILED] '+ full_name + bcolors.ENDC)
			print(bcolors.FAIL + result + bcolors.ENDC)
			for d in inc_dirs:
				print(bcolors.INFO + 'include dir: ' + d + bcolors.ENDC)
			print(bcolors.MAGENTA + '[FAILED] ' + full_name + bcolors.ENDC)
			error = True
			break
		else:
			print(bcolors.OKGREEN + '[OK] ' + bcolors.ENDC + full_name)

#stage Linking
if error == False:
	print(bcolors.HEADER + 'Linking' + bcolors.ENDC)
	result = run('{0} {1} {2}'.format(linker, lflags, objects_list))
	found = re.search(r'error:', result.lower())
	if found != None:
		print(bcolors.FAIL + result + bcolors.ENDC)
		print(bcolors.INFO + 'LFLAGS: ' + lflags + bcolors.ENDC)
		error = True
	else:
		print(bcolors.OKGREEN + 'Successfull' + bcolors.ENDC)
	
#stage Print Size
if error == False:
	result = run('{0} {1}'.format(prnsize, fname_output))
	print(bcolors.INFO + bcolors.BOLD + result + bcolors.ENDC)
	# clean
	#run('del /Q /F *.d')
	#run('del /Q /F *.o')
	