/**
 * Keil project for SDCARD reader using SPI
 *
 * Before you start, select your target, on the right of the "Load" button
 *
 * @author    Tilen Majerle
 * @email     tilen@majerle.eu
 * @website   http://stm32f4-discovery.net
 * @ide       Keil uVision 5
 * @conf      PLL parameters are set in "Options for Target" -> "C/C++" -> "Defines"
 * @packs     STM32F4xx/STM32F7xx Keil packs are requred with HAL driver support
 * @stdperiph STM32F4xx/STM32F7xx HAL drivers required
 *
 * Take a look at defines.h file for configuration
 */
/* Include core modules */
#include "stm32fxxx_hal.h"
/* Include my libraries here */
#include "defines.h"
#include "tm_stm32_delay.h"
#include "tm_stm32_fatfs.h"
#include "tm_stm32_usart.h"
#include "stdio.h"

/* Fatfs structure */
FATFS FS;
FIL fil;
FRESULT fres;

/* Size structure for FATFS */
TM_FATFS_Size_t CardSize;

/* Buffer variable */
char buffer[100];

void SysTick_Handler() {
  HAL_IncTick();	
}

int main(void) {
	/* Init system clock for maximum system speed */
//	TM_RCC_InitSystem();

	/* Initialize system */
	SystemInit();
	SystemCoreClockUpdate();
	
	/* Init HAL layer */
	HAL_Init();
	
	/* Delay init */
	TM_DELAY_Init();

	/* Initialize USART2 for debug */
	TM_USART_Init(USART2, TM_USART_PinsPack_1, 115200);
	
	/* Try to mount card */
	if (f_mount(&FS, "SD:", 1) == FR_OK) {
		/* Try to open file */
		if ((fres = f_open(&fil, "SD:Test.txt", FA_OPEN_ALWAYS | FA_READ | FA_WRITE)) == FR_OK) {
			/* Read SDCARD size */
			TM_FATFS_GetDriveSize("SD:", &CardSize);
			
			/* Format string */
			sprintf(buffer, "Total card size: %u kBytes\r\n", CardSize.Total);
			
			/* Write total card size to file */
			f_puts(buffer, &fil);
			
			TM_USART_Puts(USART2, buffer);
			
			/* Format string for free card size */
			sprintf(buffer, "Free card size:  %u kBytes\r\n", CardSize.Free);
			
			/* Write free card size to file */
			f_puts(buffer, &fil);
			
			/* Close file */
			f_close(&fil);

			TM_USART_Puts(USART2, buffer);
		} else
			TM_USART_Puts(USART2, "Error: can't open 'Test.txt'\r\n");
		
		/* Unmount SDCARD */
		f_mount(NULL, "SD:", 1);
	} else
		TM_USART_Puts(USART2, "Error: can't mount SD card\r\n");
	
	/* Do nothing */
	while (1) {
		
	}
}
