
SET output_filename=main

SET compiler_path="d:\.um\c++\labcenter\tools\SystemWorkbench_STM32\plugins\fr.ac6.mcu.externaltools.arm-none.win32_1.15.0.201708311556\tools\compiler\bin"

SET include_dirs=-I"./src" -I"./src/CMSIS/core" -I"./src/CMSIS/device"

SET linker_script=src/LinkerScript.ld

SET defines=-DDEBUG -DSTM32F401xx -DPROTEUS_DEMO
SET compile=%compiler_path%\arm-none-eabi-gcc -gdwarf-2 -mcpu=cortex-m4 -mthumb -mfloat-abi=hard -mfpu=fpv4-sp-d16 %defines% %include_dirs% -O0 -g3 -Wall -fmessage-length=0 -ffunction-sections -c -MMD -MP

rem call Compiler
%compile% -MF"main.d" -MT"main.o" -o "main.o" "src/main.c"
%compile% -MF"syscalls.d" -MT"syscalls.o" -o "syscalls.o" "src/syscalls.c"
%compile% -MF"system_stm32f4xx.d" -MT"system_stm32f4xx.o" -o "system_stm32f4xx.o" "src/system_stm32f4xx.c"

%compile% -MF"stm32f4xx_it.d" -MT"stm32f4xx_it.o" -o "stm32f4xx_it.o" "src/stm32f4xx_it.c"
%compile% -MF"stm32f4xx_gpio.d" -MT"stm32f4xx_gpio.o" -o "stm32f4xx_gpio.o" "src/stm32f4xx_gpio.c"
%compile% -MF"stm32f4xx_rcc.d" -MT"stm32f4xx_rcc.o" -o "stm32f4xx_rcc.o" "src/stm32f4xx_rcc.c"
%compile% -MF"stm32f4xx_spi.d" -MT"stm32f4xx_spi.o" -o "stm32f4xx_spi.o" "src/stm32f4xx_spi.c"
%compile% -MF"stm32f4xx_dma.d" -MT"stm32f4xx_dma.o" -o "stm32f4xx_dma.o" "src/stm32f4xx_dma.c"

%compile% -MF"tm_stm32f4_fonts.d" -MT"tm_stm32f4_fonts.o" -o "tm_stm32f4_fonts.o" "src/tm_stm32f4_fonts.c"
%compile% -MF"tm_stm32f4_gpio.d" -MT"tm_stm32f4_gpio.o" -o "tm_stm32f4_gpio.o" "src/tm_stm32f4_gpio.c"
%compile% -MF"tm_stm32f4_ili9341.d" -MT"tm_stm32f4_ili9341.o" -o "tm_stm32f4_ili9341.o" "src/tm_stm32f4_ili9341.c"
%compile% -MF"tm_stm32f4_spi.d" -MT"tm_stm32f4_spi.o" -o "tm_stm32f4_spi.o" "src/tm_stm32f4_spi.c"

rem call Assembler
%compiler_path%\arm-none-eabi-as -mcpu=cortex-m4 -mthumb -mfloat-abi=hard -mfpu=fpv4-sp-d16 %include_dirs% -g -o "startup_stm32f401xx.o" "src/startup_stm32f401xx.s"

rem call Linker 
%compiler_path%\arm-none-eabi-gcc -mcpu=cortex-m4 -mthumb -mfloat-abi=hard -mfpu=fpv4-sp-d16 -T"%linker_script%" -Wl,-Map=%output_filename%.map -Wl,--gc-sections -o "%output_filename%.elf" @"src/objects.list" -lm

rem Printing size information
%compiler_path%\arm-none-eabi-size "%output_filename%.elf"
 
del *.d
del *.o

